﻿using RemiseANiveau2.Entities.fixtures;
using RemiseANiveau2.Repository.Contracts;

namespace RemiseANiveau2.Repository
{
        /// <summary>
        /// Classe dépôt de versions
        /// </summary>
    public class VersionRepository : IVersionRepository
    {
        private static List<Entities.Version> versions = FactoryVersion.GetVersions();

          /// <inheritdoc/>
        public void Add(Entities.Version Version)
        {

            bool Existe = VersionRepository.versions.Any(v => v.Numero == Version.Numero);

            if (!Existe)
            {
                VersionRepository.versions.Add(Version);

            }
        }

        /// <inheritdoc/>
        public List<Entities.Version> FindAll()
        {
            return VersionRepository.versions;
        }

        /// <inheritdoc/>
        public void Remove(Entities.Version Version)
        {
            var VersionASupp = this.FindAll().First(v => v.Numero == Version.Numero && v.Date == Version.Date);
            VersionRepository.versions.Remove(VersionASupp);
        }

        /// <inheritdoc/>
        public int Count()
        {
            return this.FindAll().Count();
        }

        /// <inheritdoc/>
        public Entities.Version First()
        {
            return this.FindAll().First();
        }

        /// <inheritdoc/>
        public Entities.Version Last()
        {
            return this.FindAll().Last();
        }

        /// <inheritdoc/>
        public List<Entities.Version> Après5eme()
        {
            List<Entities.Version> ListeDesVersionsApres5 = this.FindAll().Skip(5).Take(3).ToList();

            return ListeDesVersionsApres5;
        }

        /// <inheritdoc/>
        public List<Entities.Version> OrderByNum()
        {
            return this
                .FindAll()
                .OrderBy(v => double.Parse(v.Numero))
                .ToList();
        }

        /// <inheritdoc/>
        public List<Entities.Version> OrderBy()
        {
            return this
                .FindAll()
                .OrderBy(v => double.Parse(v.Numero))
                .ThenBy(v => DateTime.Parse(v.Date))
                .ToList();
        }

        /// <inheritdoc/>
        public dynamic Anon()
        {
            var anon = this
                .FindAll()
                .Select(v => new { v.Numero });

            return anon.First().Numero.ToString() ;
        }
    }
}
